IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE TYPE = 'TR' AND name = 'CT_Clientes_CD_Clientes_Novedades_Upd')
BEGIN
    DROP TRIGGER dbo.CT_Clientes_CD_Clientes_Novedades_Upd 
END
GO

CREATE TRIGGER [dbo].[CT_Clientes_CD_Clientes_Novedades_Upd] ON [dbo].[Clientes]
AFTER UPDATE
AS 
SET NOCOUNT ON
DECLARE @Id_Cliente					INT
DECLARE @Id_Novedad_Pendiente		INT
DECLARE @xParam_CD_Cli_Noved_Ejecut	INT

--INSERT y UPDATE estan separados los Trigger porque en Clarion mantiene todo en Memoria y luego graba todo junto.

SET @xParam_CD_Cli_Noved_Ejecut = ISNULL(CONVERT(INT, dbo.CF_xParam('CD_Cli_Noved_Ejecut')), 0)

IF (@xParam_CD_Cli_Noved_Ejecut <> 0)
BEGIN
	SET NOCOUNT ON
	DECLARE cur_CT_Clientes_CD_Clientes_Novedades_Upd cursor for 
	SELECT I.Id_Cliente
	FROM Inserted I LEFT OUTER JOIN Deleted D ON I.Id_Cliente = D.Id_Cliente
	WHERE
	(ISNULL(I.Id_Tipo_Cli, 0) <> ISNULL(D.Id_Tipo_Cli, 0)) OR
	(ISNULL(I.Activo, 0) <> ISNULL(D.Activo, 0)) OR
	(ISNULL(I.Fecha_Alta, '19000101') <> ISNULL(D.Fecha_Alta, '19000101')) OR
	(ISNULL(I.Fecha_Baja, '19000101') <> ISNULL(D.Fecha_Baja, '19000101')) OR
	(ISNULL(I.Id_Cliente_Ref, 0) <> ISNULL(D.Id_Cliente_Ref, 0)) OR
	(ISNULL(I.Credencial_Nro, '') <> ISNULL(D.Credencial_Nro, '')) OR
	(ISNULL(I.Id_Tipo_Cli, 0) <> ISNULL(D.Id_Tipo_Cli, 0))


	OPEN cur_CT_Clientes_CD_Clientes_Novedades_Upd
	FETCH NEXT FROM cur_CT_Clientes_CD_Clientes_Novedades_Upd INTO @Id_Cliente
	WHILE @@FETCH_STATUS = 0
	BEGIN
	
		SET @Id_Novedad_Pendiente = ISNULL(	(SELECT MAX(Id_Novedad)
											FROM CD_Clientes_Novedades
											WHERE
											Estado = 'P'
											AND Id_Cliente = @Id_Cliente)
											, 0)
		IF(@Id_Novedad_Pendiente > 0)
		BEGIN
			UPDATE CD_Clientes_Novedades
			SET
			Fecha = GETDATE()
			WHERE
			Estado = 'P'
			AND Id_Cliente = @Id_Cliente
		END
		ELSE
		BEGIN
			INSERT INTO CD_Clientes_Novedades
			(Id_Cliente,		Fecha,		Estado)
			VALUES
			(@Id_Cliente,		GETDATE(),	'P')
		END

		FETCH NEXT FROM cur_CT_Clientes_CD_Clientes_Novedades_Upd INTO @Id_Cliente
	END
	CLOSE cur_CT_Clientes_CD_Clientes_Novedades_Upd
	DEALLOCATE cur_CT_Clientes_CD_Clientes_Novedades_Upd
END